* This program practice FIXED EFFECTS and FIRST DIFFERENCES in the context of the wage premium in finance using NLSY79 data set


# delimit;
clear ;
set more off ;

set matsize 11000 ;

capture log close ;


/*
GLOBALS
INSERET THE LOCATION/FOLDER ON YOUR COMPUTER
*/

global FOLDER "/Users/yonarubinstein/Dropbox/TEACHING/LSE/MG4A4 EMPIRICAL RESEARCH STRATEGY FOR MANAGERIAL ECONOMICS/POST/DATA AND PROGRAMS/" ;

cd "$LOG/" ;


log using "$FOLDER/MG4A4 FIXED EFFECTS IN PRACTICE USING THE NLSY79.log", replace ;



/* ********************************************************************************************************* */
/* ******************************************** UPLOAD THE FILE ******************************************** */
/* ********************************************************************************************************* */


use "$FOLDER/MG4A4_NLSY79_2555.dta", clear ;



/*
(1) DESCRIBE
*/

des 
id year _SEXi _RACEi _AFQTi _ILLICTi _ROTTERi _ROSENBERGi _Sit _EXP1it _EXP2it 
_FINANCEit _TYPEWRKRit _FTFYit _HRSWRKit _WAGERit _HWRit _Wit ;


/*
(2) SUMMARIZE
*/

sum
id year _SEXi _RACEi _AFQTi _ILLICTi _ROTTERi _ROSENBERGi _Sit _EXP1it _EXP2it 
_FINANCEit _TYPEWRKRit _FTFYit _HRSWRKit _WAGERit _HWRit _Wit ;

sort _FINANCEit ;

by _FINANCEit: sum

id year _SEXi _RACEi _AFQTi _ILLICTi _ROTTERi _ROSENBERGi _Sit _EXP1it _EXP2it 
_FINANCEit _TYPEWRKRit _FTFYit _HRSWRKit _WAGERit _HWRit _Wit ;



use "$FOLDER/MG4A4_NLSY79_2555.dta", clear ;

collapse

(count)

N=id

(mean)

_SEXi _RACEi _AFQTi _ILLICTi _ROTTERi _ROSENBERGi _Sit _EXP1it
_TYPEWRKRit _FTFYit _HRSWRKit _WAGERit _HWRit _Wit, by(_FINANCEit);

save "$FOLDER/MG4A4_FIXED_EFFECTS_MEANS.dta", replace ;



use "$FOLDER/MG4A4_NLSY79_2555.dta", clear ;

collapse

(count)

N=id

(sd)

_SEXi _RACEi _AFQTi _ILLICTi _ROTTERi _ROSENBERGi _Sit _EXP1it
_TYPEWRKRit _FTFYit _HRSWRKit _WAGERit _HWRit _Wit, by(_FINANCEit);

save "$FOLDER/MG4A4_FIXED_EFFECTS_SD.dta", replace ;



use "$FOLDER/MG4A4_NLSY79_2555.dta", clear ;

collapse

(count)

N=id

(min)

_SEXi _RACEi _AFQTi _ILLICTi _ROTTERi _ROSENBERGi _Sit _EXP1it
_TYPEWRKRit _FTFYit _HRSWRKit _WAGERit _HWRit _Wit, by(_FINANCEit);

save "$FOLDER/MG4A4_FIXED_EFFECTS_MIN.dta", replace ;




use "$FOLDER/MG4A4_NLSY79_2555.dta", clear ;

collapse

(count)

N=id

(max)

_SEXi _RACEi _AFQTi _ILLICTi _ROTTERi _ROSENBERGi _Sit _EXP1it
_TYPEWRKRit _FTFYit _HRSWRKit _WAGERit _HWRit _Wit, by(_FINANCEit);

save "$FOLDER/MG4A4_FIXED_EFFECTS_MAX.dta", replace ;


use "$FOLDER/MG4A4_FIXED_EFFECTS_MEANS.dta", clear ;
append using "$FOLDER/MG4A4_FIXED_EFFECTS_SD.dta" ;
append using "$FOLDER/MG4A4_FIXED_EFFECTS_MIN.dta" ;
append using "$FOLDER/MG4A4_FIXED_EFFECTS_MAX.dta" ;

sort _FINANCEit ;

save "$FOLDER/MG4A4_FIXED_EFFECTS_SUMMARY.dta", replace ;



/*
(4) TEST BALANCED TREATMENT COMPARISON
*/


use "$FOLDER/MG4A4_NLSY79_2555.dta", clear ;


gen _x1 = _AFQTi  ;
gen _x2 = _ROSENBERGi  ;
gen _x3 = _ROTTERi ;
gen _x4 = _ILLICTi ;
gen _x5 = _Sit ;
gen _x6 = _EXP1it ;
gen _x7 = _HRSWRKit ;
gen _x8 = _WAGEit ;
gen _x9 = _HWRit ;
gen _x10 = _Wit ;

keep id year _FINANCEit _x1 _x2 _x3 _x4 _x5 _x6 _x7 _x8 _x9 _x10 ;

save "$FOLDER/MG4A4_FIXED_EFFECTS_BALANCED.dta", replace ;

use "$FOLDER/MG4A4_FIXED_EFFECTS_BALANCED.dta", clear ;


local i    = 1 ;
local endi =11 ;

while `i' < `endi' { ;

reg _x`i' _FINANCEit, robust cluster (id) ;

regsave, tstat pval ci ;

gen D=`i' ;

save "$FOLDER/MG4A4_FIXED_EFFECTS_BALANCED`i'.dta", replace ;

use "$FOLDER/MG4A4_FIXED_EFFECTS_BALANCED.dta", clear ;

local i = `i' + 1 ;

} ;


use "$FOLDER/MG4A4_FIXED_EFFECTS_BALANCED1.dta" ;

local i    = 2 ;
local endi =11 ;

while `i' < `endi' { ;

append using "$FOLDER/MG4A4_FIXED_EFFECTS_BALANCED`i'.dta" ;

save "$FOLDER/MG4A4_FIXED_EFFECTS_BALANCED.dta", replace ;

local i = `i' + 1 ;

} ;



gen X="_AFQTi" if D==1 ;
replace X="_ROSENBERGi" if D==2 ;
replace X="_ROTTERi" if D==3 ;
replace X="_ILLICTi" if D==4 ;
replace X="_Sit" if D==5 ;
replace X="_EXP1it" if D==6 ;
replace X="_HRSWRKit" if D==7 ;
replace X="_WAGEit" if D==8 ;
replace X="_HWRit"  if D==9 ;
replace X="_Wit"    if D==10 ;

order X ;

sort var D ;

save "$FOLDER/MG4A4_FIXED_EFFECTS_BALANCED.dta", replace ;


/* *************************************************************************** */
/* ***************************** WAGE REGRESSIONS **************************** */
/* *************************************************************************** */

/*
(5) WAGE REGRESSIONS
*/

use "$FOLDER/MG4A4_NLSY79_2555.dta", clear ;

xi: reg _Wit _FINANCEit i.year  ;
estimates store OLS1, title((CRUDE1));


xi:reg _Wit _FINANCEit _AFQTi _ROSENBERGi _ROTTERi _Sit _EXP1it _EXP2it i.year ;
estimates store OLS2, title((RESID1));


xi:areg _Wit _FINANCEit _AFQTi _ROSENBERGi _ROTTERi _Sit _EXP1it _EXP2it i.year, absorb(id);
estimates store FE1, title((RESID1));


xi:xtreg _Wit _FINANCEit _AFQTi _ROSENBERGi _ROTTERi _Sit _EXP1it _EXP2it i.year, fe i(id);
estimates store FE2, title((RESID2));


estout OLS1 OLS2 FE1 FE2 using "$FOLDER/MG4A4 FIXED EFFECTS IN PRACTICE USING THE NLSY79 1.txt", 
replace keep 
(_cons _FINANCEit _AFQTi _ROSENBERGi _ROTTERi _Sit _EXP1it _EXP2it)
cells(b(star fmt(3)) se(par fmt (3)))
varlabels(_cons Constant)
stats(N r2 , fmt(0 3 0) labels(Observations R-square))
starlevels(* 0.10 ** 0.05 *** 0.01)
prehead("TABLE 1" "REGRESSION COEFFICIENTS")
posthead("")
prefoot("")
postfoot(""
"Notes."
"TBA"
"Robust standard errors clustered statefip in parentheses."
"* Significant at 10%; ** significant at 5%; *** significant at 1%." ) ;

drop _est* ;






/*
(6) WAGE REGRESSIONS BEFOE - AFTER 1996
*/
use "$DATA/MG4A4_NLSY79_2555.dta", clear ;

xi: reg _Wit _FINANCEit _Sit _EXP1it _EXP2it i.year if year<1996 ;
estimates store OLS1, title((RESID1));


xi: reg _Wit _FINANCEit _Sit _EXP1it _EXP2it i.year if year>=1996 ;
estimates store OLS2, title((RESID1));


xi: areg _Wit _FINANCEit _Sit _EXP1it _EXP2it i.year if year<1996, absorb(id);
estimates store FE1, title((RESID2));

xi: areg _Wit _FINANCEit _Sit _EXP1it _EXP2it i.year if year>=1996, absorb(id);
estimates store FE2, title((RESID2));


estout OLS1 FE1 OLS2 FE2 using "$FOLDER/MG4A4 FIXED EFFECTS IN PRACTICE USING THE NLSY79 2.txt", 
replace keep 
(_cons _FINANCEit _Sit _EXP1it _EXP2it)
cells(b(star fmt(3)) se(par fmt (3)))
varlabels(_cons Constant)
stats(N r2 , fmt(0 3 0) labels(Observations R-square))
starlevels(* 0.10 ** 0.05 *** 0.01)
prehead("TABLE 2" "REGRESSION COEFFICIENTS")
posthead("")
prefoot("")
postfoot(""
"Notes."
"TBA"
"Robust standard errors clustered statefip in parentheses."
"* Significant at 10%; ** significant at 5%; *** significant at 1%." ) ;

drop _est* ;



/*
(5) REGRESSIONS FIXED EFFECTS AND DIF
*/


sort id year ;

gen _dWit = _Wit - _Wit[_n-1] ;
replace _dWit = . if id~=id[_n-1] ;

gen _dFINANCEit = _FINANCEit - _FINANCEit[_n-1] ;
replace _dFINANCEit = . if id~=id[_n-1] ;

gen _dEXP1it = _EXP1it - _EXP1it[_n-1] ;
replace _dEXP1it = . if id~=id[_n-1] ;

gen _dEXP2it = _EXP2it - _EXP2it[_n-1] ;
replace _dEXP2it = . if id~=id[_n-1] ;


xi: reg _Wit _FINANCEit _EXP1it _EXP2it i.year _AFQTi _ROSENBERGi _ROTTERi _Sit , cluster(id) ;
estimates store OLS1, title(OLS);

xi: areg _Wit _FINANCEit _EXP1it _EXP2it i.year, absorb(id) ;
estimates store FE1, title(FE);

xi: reg _dWit _dFINANCEit _dEXP1it _dEXP2it i.year ;
estimates store DIF1, title(DIF);

xi: areg _dWit _dFINANCEit _dEXP1it _dEXP2it i.year, absorb(id);
estimates store DIF2, title(DIF&FE);



estout OLS1 FE1 DIF1 DIF2 using "$FOLDER/MG4A4 FIXED EFFECTS IN PRACTICE USING THE NLSY79 3.txt", 
replace keep 
(_cons _FINANCEit _dFINANCEit)
cells(b(star fmt(3)) se(par fmt (3)))
varlabels(_cons Constant)
stats(N r2 , fmt(0 3 0) labels(Observations R-square))
starlevels(* 0.10 ** 0.05 *** 0.01)
prehead("TABLE 3" "REGRESSION COEFFICIENTS DIF FE")
posthead("")
prefoot("")
postfoot(""
"Notes."
"TBA"
"Robust standard errors clustered statefip in parentheses."
"* Significant at 10%; ** significant at 5%; *** significant at 1%." ) ;



log close ;
